//
//  TTTGame.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/4/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTGame.h"

@implementation TTTGame
	
	-(id) init { //Constructor
		gameGrid = [[TTTGameGrid alloc] init];
		gameState = Active;
		currentSymbol = [TTTSymbol SymbolXCreate];
        currentPlayer = Player1;
        return self;
	}
	
	- (TTTGameGrid *) getGameGrid{
		return gameGrid;
	}

    - (void) setPlayerNames :(NSString *) FirstPlayer : (NSString *) SecondPlayer{
		PlayerOneName = FirstPlayer; PlayerTwoName = SecondPlayer;
	}

	- (NSString *) getPlayerOneName{ return PlayerOneName; }

	- (NSString *) getPlayerTwoName{ return PlayerTwoName; }

	- (NSString *) getCurrentPlayerName {
		if (currentPlayer == Player1) return PlayerOneName; else return PlayerTwoName;
	}

	- (NSString *)  getWinningPlayerName {
		if (winningPlayer == Player1) return PlayerOneName; else return PlayerTwoName;
	}

	- (TTTSymbol *) getCurrentSymbol{
		return currentSymbol;
	}

    - (void) checkResultAndSetState{
        if([gameGrid isRowFilled:0]||
           [gameGrid isRowFilled:1]||
           [gameGrid isRowFilled:2]||
           [gameGrid isColumnFilled:0]||
           [gameGrid isColumnFilled:1]||
           [gameGrid isColumnFilled:2]||
           [gameGrid isLeftToRightDiagonalFilled]||
           [gameGrid isRightToLeftDiagonalFilled]){
            winningPlayer = currentPlayer;
            gameState = Won;
        }else if (playCount==9){
            gameState = Draw;
        } /* else, leave state as is */
    }

    - (BOOL) play :(int) x :(int) y{
		BOOL successfulPlay=false;
        if ([gameGrid getSymbolAtLocation :x :y] == [TTTSymbol SymbolBlankCreate]){
			successfulPlay = true;
			playCount++;
            [gameGrid setSymbolAtLocation :x :y :currentSymbol];
			[self checkResultAndSetState];
			if(gameState == Active){// if the game is still active
				// Swap symbols and players
				if(currentSymbol == [TTTSymbol SymbolXCreate]){
					currentSymbol= [TTTSymbol SymbolOCreate];
				} else {
					currentSymbol= [TTTSymbol SymbolXCreate];
                }
				if(currentPlayer == Player1) currentPlayer = Player2; else currentPlayer = Player1;
			}
		}
		return successfulPlay;
	}

	
	- (BOOL) isActive{
		return gameState == Active;
	}

	- (BOOL) isWon{
		return gameState == Won;
	}
	- (BOOL) isDrawn{
		return gameState == Draw;
	}
	- (int) getPlayCount{
		return playCount;
	}

@end
